local cockpit = folder.."../../../cockpit/C-101CC/"
dofile(cockpit.."../Common/devices_common.lua")
dofile(cockpit.."devices.lua")
dofile(cockpit.."../Common/command_defs.lua")
local base = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")
local rearCptSuffix = _('(Rear Cockpit)')

join(base.keyCommands,{

-- debug commands
--{down = iCommandReloadTables, name = 'Reload tables', category = _('Cheat')},
--{combos = {{key = 'X', reformers = {'LShift', 'LCtrl', 'LAlt'}}}, down = iCommandViewExplosion,	up = iCommandViewExplosion,	name = 'cheat camera fire', category = _('Debug')},

-------------------------------------------------------------Main panel----------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

-- Flight director
{combos = {{key = 'Num7', reformers = {'LCtrl'}}}, down = device_commands.Button_171, up = device_commands.Button_171, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD HEADING mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num8', reformers = {'LCtrl'}}}, down = device_commands.Button_174, up = device_commands.Button_174, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD NAV MODE mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num9', reformers = {'LCtrl'}}}, down = device_commands.Button_175, up = device_commands.Button_175, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD APP mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num4', reformers = {'LCtrl'}}}, down = device_commands.Button_176, up = device_commands.Button_176, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD BC mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num5', reformers = {'LCtrl'}}}, down = device_commands.Button_177, up = device_commands.Button_177, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD VOR APP mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num6', reformers = {'LCtrl'}}}, down = device_commands.Button_172, up = device_commands.Button_172, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD ALTITUDE mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num2', reformers = {'LCtrl'}}}, down = device_commands.Button_178, up = device_commands.Button_178, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD VS mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num3', reformers = {'LCtrl'}}}, down = device_commands.Button_179, up = device_commands.Button_179, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD IAS mode'), category = {_('Main instrument panel'), _('Flight director')}},
{combos = {{key = 'Num0', reformers = {'LCtrl'}}}, down = device_commands.Button_170, up = device_commands.Button_170, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('FD STBY mode'), category = {_('Main instrument panel'), _('Flight director')}},

{combos = {},	down = device_commands.Button_195,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('FD Panel Brightness Switch - ON'),category = {_('Main instrument panel'), _('Flight director')}},
{combos = {},	down = device_commands.Button_195,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('FD Panel Brightness Switch - OFF'),	category = {_('Main instrument panel'), _('Flight director')}},

--Scar display panel
{combos = {{key = 'S', reformers = {'LShift'}}}, down = device_commands.Button_271, up = device_commands.Button_271, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('SCAR Mode selector/cancel'), category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons')}},

{combos = {{key = 'C', reformers = {'RCtrl'}}},	down = device_commands.Button_710, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('SCAR Initial cannon load Decrease'), category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons')}},
{combos = {{key = 'C', reformers = {'RShift'}}},down = device_commands.Button_710, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('SCAR Initial cannon load Increase'), category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons')}},

--RGS2 sighting system
{combos = {},down = device_commands.Button_317, up = device_commands.Button_317, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, value_up = 0.5, name = _('Optical Sight Mode Switch - Test'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_317, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _('Optical Sight Mode Switch - Man'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_317, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Optical Sight Mode Switch - Auto'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {},down = device_commands.Button_318, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Optical Sight Switch - OFF'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_318, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Optical Sight Switch - ON'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {},down = device_commands.Button_712, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Optical Sight Depression Hundreds (0XX) Selector - Decrease'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_712, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Optical Sight Depression Hundreds (0XX) Selector - Increase'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {},down = device_commands.Button_713, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Optical Sight Depression Tens (X0X) Selector - Decrease'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_713, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Optical Sight Depression Tens (X0X) Selector - Increase'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {},down = device_commands.Button_714, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Optical Sight Depression Units (XX0) Selector - Decrease'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},down = device_commands.Button_714, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Optical Sight Depression Units (XX0) Selector - Increase'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {},pressed = device_commands.Button_311, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Optical Sight Brightness Decrease'), category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {},pressed = device_commands.Button_311, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Optical Sight Brightness Increase'), category = {_('RGS2 sighting system'), _('Weapons')}},

{combos = {{key = '='}},pressed = iCommandPlaneIncreaseBase_Distance, up = iCommandPlaneStopBase_Distance , name = _('Range Selector Next')	, category = {_('RGS2 sighting system'), _('Weapons')}},
{combos = {{key = '-'}},pressed = iCommandPlaneDecreaseBase_Distance, up = iCommandPlaneStopBase_Distance , name = _('Range Selector Previous'), category = {_('RGS2 sighting system'), _('Weapons')}},

-- Jettison Panel
{combos = {{key = 'J', reformers = {'LCtrl'}}}, down = device_commands.Button_268, up = device_commands.Button_268, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Emergency jettison button'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {{key = 'J', reformers = {'LAlt'}}}, down = device_commands.Button_269, up = device_commands.Button_269, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Scar light test'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

--  SCAR control panel
{combos = {}, down = device_commands.Button_262, up = device_commands.Button_262, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #1'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {}, down = device_commands.Button_263, up = device_commands.Button_263, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #2'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {}, down = device_commands.Button_264, up = device_commands.Button_264, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #3'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {}, down = device_commands.Button_265, up = device_commands.Button_265, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #4'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {}, down = device_commands.Button_266, up = device_commands.Button_266, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #5'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {}, down = device_commands.Button_267, up = device_commands.Button_267, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pylon select #6'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_254, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Master mode cover CLOSE'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_254, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Master mode cover OPEN'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_255, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Master mode A/G'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_255, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _('Master mode OFF'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_255, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Master mode A/A'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_256, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Master arm OFF'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_256, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Master arm ON'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_706, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Mode selector Decrease'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_706, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Mode selector Increase'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0, name = _('Mode selector NC'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.142, name = _('Mode selector RIP'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.284, name = _('Mode selector BOMB'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.426, name = _('Mode selector SAF'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.568, name = _('Mode selector BM'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.71, name = _('Mode selector ROC'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.852, name = _('Mode selector I-I'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_258, cockpit_device_id = devices.SYSTEMS, value_down = 0.994, name = _('Mode selector BRST'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_707, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Bomb arming selector Decrease'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_707, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Bomb arming selector Increase'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_257, cockpit_device_id = devices.SYSTEMS, value_down = 0, name = _('Bomb arming selector OFF'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_257, cockpit_device_id = devices.SYSTEMS, value_down = 0.33, name = _('Bomb arming selector NS/TL'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_257, cockpit_device_id = devices.SYSTEMS, value_down = 0.66, name = _('Bomb arming selector NS'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_257, cockpit_device_id = devices.SYSTEMS, value_down = 0.99, name = _('Bomb arming selector TL'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_708, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Ripple time Decrease'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_708, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Ripple time Increase'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_259, cockpit_device_id = devices.SYSTEMS, value_down = 0, name = _('Ripple time 70'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_259, cockpit_device_id = devices.SYSTEMS, value_down = 0.25, name = _('Ripple time 90'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_259, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _('Ripple time 120'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_259, cockpit_device_id = devices.SYSTEMS, value_down = 0.75, name = _('Ripple time 150'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_259, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Ripple time 200'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_709, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Selective jettison selector Decrease'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_709, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Selective jettison selector Increase'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {},down = device_commands.Button_260, cockpit_device_id = devices.SYSTEMS, value_down = 0, name = _('Selective jettison selector OFF'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_260, cockpit_device_id = devices.SYSTEMS, value_down = 0.33, name = _('Selective jettison selector IN'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_260, cockpit_device_id = devices.SYSTEMS, value_down = 0.66, name = _('Selective jettison selector CEN'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},
{combos = {},down = device_commands.Button_260, cockpit_device_id = devices.SYSTEMS, value_down = 0.99, name = _('Selective jettison selector OUT'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},

{combos = {}, down = device_commands.Button_261, up = device_commands.Button_261, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Selective jettison button'), category = {_('Main instrument panel'), _('SCAR control panel'), _('Weapons')}},


--CAMERA
--{combos = {},down = device_commands.Button_312, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Video OFF'), category = _('Systems')},
--{combos = {},down = device_commands.Button_312, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _('Video STB'), category = _('Systems')},
--{combos = {},down = device_commands.Button_312, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Video REC'), category = _('Systems')},

--{combos = {},down = device_commands.Button_313, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Video rec OFF'), category = _('Systems')},
--{combos = {},down = device_commands.Button_313, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Video rec ON'), category = _('Systems')},

--AOA

{combos = {},pressed = device_commands.Button_723, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('AOA indicator knob Decrease'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_723, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('AOA indicator knob Increase'), category = _('Main instrument panel')},

--Altimeter
{combos = {{key = 'B', reformers = {'RCtrl'}}},	pressed = device_commands.Button_19, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Altimeter setting knob - Decrease'), category = _('Main instrument panel')},
{combos = {{key = 'B', reformers = {'RShift'}}},pressed = device_commands.Button_19, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Altimeter setting knob - Increase'), category = _('Main instrument panel')},

{combos = {{key = 'V', reformers = {'RCtrl'}}},	pressed = device_commands.Button_21, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Standby altimeter setting knob - Decrease'), category = _('Main instrument panel')},
{combos = {{key = 'V', reformers = {'RShift'}}},pressed = device_commands.Button_21, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Standby altimeter setting knob - Increase'), category = _('Main instrument panel')},


--Fuel flow
{combos = {{key = 'F', reformers = {'RCtrl'}}}, down = device_commands.Button_234, up = device_commands.Button_234, cockpit_device_id = devices.SYSTEMS,value_down = 0.0,value_up = 1.0, name = _('Fuel flow Reset'), category = _('Main instrument panel')},
{combos = {{key = 'F', reformers = {'RShift'}}},down = device_commands.Button_235, up = device_commands.Button_235, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuel flow test'), category = _('Main instrument panel')},

--Acceleration g units
{combos = {{key = 'G', reformers = {'LShift'}}}, down = device_commands.Button_42, up = device_commands.Button_42, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Reset Max/Min Needles'), category = _('Main instrument panel')},

--Markers
{combos = {}, down = device_commands.Button_167, up = device_commands.Button_167, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Outer marker lamp test'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_168, up = device_commands.Button_168, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Middle marker lamp test'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_169, up = device_commands.Button_169, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Inner marker lamp test'), category = _('Main instrument panel')},

{combos = {}, pressed = device_commands.Button_907, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Outer Marker Dimmer Increase'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_907, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Outer Marker Dimmer Decrease'), category = _('Main instrument panel')},

{combos = {}, pressed = device_commands.Button_909, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Middle Marker Dimmer Increase'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_909, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Middle Marker Dimmer Decrease'), category = _('Main instrument panel')},

{combos = {}, pressed = device_commands.Button_911, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Inner Marker Dimmer Increase'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_911, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Inner Marker Dimmer Decrease'), category = _('Main instrument panel')},

--HSI
{combos = {}, down = device_commands.Button_349, up = device_commands.Button_349, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Bearing select pushbutton'), category = _('Main instrument panel')},

--HSI Brightness
{combos = {{key = 'H', reformers = {'RCtrl'}}},pressed = device_commands.Button_180, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('HSI digit brightness Decrease'), category = _('Main instrument panel')},
{combos = {{key = 'H', reformers = {'RShift'}}},pressed = device_commands.Button_180, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('HSI digit brightness Increase'), category = _('Main instrument panel')},

--Korry Buttons- UHF, VHF, NAV
{combos = {{key = 'N', reformers = {'LAlt'}}}, down = device_commands.Button_119, up = device_commands.Button_119, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('NAV Priority'), category = _('Main instrument panel')},
{combos = {{key = 'U', reformers = {'LAlt'}}}, down = device_commands.Button_162, up = device_commands.Button_162, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('UHF Priority'), category = _('Main instrument panel')},
{combos = {{key = 'V', reformers = {'LAlt'}}}, down = device_commands.Button_163, up = device_commands.Button_163, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VHF Priority'), category = _('Main instrument panel')},

--ADI
{combos = {{key = 'A', reformers = {'LAlt'}}}, down = device_commands.Button_166, up = device_commands.Button_166, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Attitude test'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_346, up = device_commands.Button_346, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Radio altitude test switch'), category = _('Main instrument panel')},

{combos = {},pressed = device_commands.Button_348, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('DH SET radio altimeter Decrease'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_348, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('DH SET radio altimeter Increase'), category = _('Main instrument panel')},

--{combos = {},pressed = device_commands.Button_348, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('DIM ADI radio altimeter Decrease'), category = _('Main instrument panel')},
--{combos = {},pressed = device_commands.Button_348, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('DIM ADI radio altimeter Increase'), category = _('Main instrument panel')},

--Clock
{combos = {{key = 'Q', reformers = {'LAlt'}}}, down = device_commands.Button_149, up = device_commands.Button_149, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Chronograph'), category = _('Main instrument panel')},

{combos = {{key = 'Q', reformers = {'RCtrl'}}},pressed = device_commands.Button_147, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.0, name = _('Clock set button - Push'), category = _('Main instrument panel')},
{combos = {{key = 'Q', reformers = {'RShift'}}},pressed = device_commands.Button_147, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Clock set button - Pull'), category = _('Main instrument panel')},

{combos = {{key = 'Q', reformers = {'LCtrl'}}},pressed = device_commands.Button_148, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.008, name = _('Clock Setting Knob - Counterclockwise'), category = _('Main instrument panel')},
{combos = {{key = 'Q', reformers = {'LShift'}}},pressed = device_commands.Button_148, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.008, name = _('Clock Setting Knob - Clockwise'), category = _('Main instrument panel')},


--Back up ADI
{combos = {{key = 'H', reformers = {'LAlt'}}}, down = device_commands.Button_14, up = device_commands.Button_14, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Backup ADI Cage'), category = _('Main instrument panel')},

{combos = {{key = 'H', reformers = {'LCtrl'}}}, pressed = device_commands.Button_922, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Pitch Reference Adjust Decrease'), category = _('Main instrument panel')},
{combos = {{key = 'H', reformers = {'LShift'}}},pressed = device_commands.Button_922, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Pitch Reference Adjust Increase'), category = _('Main instrument panel')},

--V/UHF RADIO V/TVU-740
{combos = {}, pressed = device_commands.Button_51, up = device_commands.Button_51, cockpit_device_id  = devices.VTWU740, value_pressed = -1.0, value_up = 0.0, name = _('UHF - Test selector - R'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {}, pressed = device_commands.Button_62, up = device_commands.Button_62, cockpit_device_id  = devices.VTWU740, value_pressed = 1.0, value_up = 0.0, name = _('UHF - Test selector - T-A2'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_52, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - 0XX.XXX Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_52, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - 0XX.XXX Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_53, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - X0X.XXX Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_53, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - X0X.XXX Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_54, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XX0.XXX Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_54, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XX0.XXX Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_55, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XXX.0XX Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_55, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XXX.0XX Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_56, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XXX.X00 Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_56, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XXX.X00 Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_57, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Main selector Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_57, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Main selector Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_7, cockpit_device_id  = devices.VTWU740, value_down = 0, name = _('UHF - Main selector OFF'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_7, cockpit_device_id  = devices.VTWU740, value_down = 0.1, name = _('UHF - Main selector A3'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_7, cockpit_device_id  = devices.VTWU740, value_down = 0.2, name = _('UHF - Main selector A3+G'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_7, cockpit_device_id  = devices.VTWU740, value_down = 0.3, name = _('UHF - Main selector DF'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_58, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Mode Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_58, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Mode Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_8, cockpit_device_id  = devices.VTWU740, value_down = 0, name = _('UHF - Mode G'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_8, cockpit_device_id  = devices.VTWU740, value_down = 0.5, name = _('UHF - Mode M'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_8, cockpit_device_id  = devices.VTWU740, value_down = 1, name = _('UHF - Mode P'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_59, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Squelch OFF'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_59, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Squelch ON'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.VTWU740, value_pressed = -1.0, name = _('UHF - Power transmit selector - 20W'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.VTWU740, value_pressed = 1.0, name = _('UHF - Power transmit selector - 5W'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

{combos = {},down = device_commands.Button_61, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Channel selector Decrease'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},
{combos = {},down = device_commands.Button_61, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Channel selector Increase'), category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740')}},

--Korry CAUTION, ANTISKID...
{combos = {{key = 'M', reformers = {'LShift'}}}, down = device_commands.Button_16, up = device_commands.Button_16, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fault Alert Reset'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_43, up = device_commands.Button_43, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Antiskid ON/OFF'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_17, up = device_commands.Button_17, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fire Alert test'), category = _('Main instrument panel')},
{combos = {{key = 'M', reformers = {'RShift'}}}, down = device_commands.Button_18, up = device_commands.Button_18, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Caution Alert Reset'), category = _('Main instrument panel')},

--Gyro Platform Control Panel
{combos = {},down = device_commands.Button_325, up = device_commands.Button_325, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fast erect pushbutton'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

{combos = {},down = device_commands.Button_326, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Mag var control 15W'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},down = device_commands.Button_326, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _('Mag var control 0'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},down = device_commands.Button_326, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Mag var control 15E'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

{combos = {},down = device_commands.Button_327, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Hemisphere switch S'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},down = device_commands.Button_327, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Hemisphere switch N'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

{combos = {},down = device_commands.Button_328, cockpit_device_id = devices.SYSTEMS, value_down = -1, name = _('Function selector switch Decrease'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},down = device_commands.Button_328, cockpit_device_id = devices.SYSTEMS, value_down = 1, name = _('Function selector switch Increase'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

{combos = {},pressed = device_commands.Button_356, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Synchronizer and heading set Decrease'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},pressed = device_commands.Button_356, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Synchronizer and heading set Increase'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

{combos = {},pressed = device_commands.Button_334, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Latitude correction control Decrease'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},
{combos = {},pressed = device_commands.Button_334, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Latitude correction control Increase'), category = {_('Main instrument panel'), _('Gyro platform control panel')}},

--IFF
{combos = {},down = device_commands.Button_218, up = device_commands.Button_218, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('IFF reply lamp test'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {}, pressed = device_commands.Button_918, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('IFF Reply Test Lamp Increase'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},pressed = device_commands.Button_918, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('IFF Reply Test Lamp Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_219, up = device_commands.Button_219, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('IFF test'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {}, pressed = device_commands.Button_919, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('IFF Test Light Increase'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},pressed = device_commands.Button_919, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('IFF Test Light Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Audio light switch - LIGHT'),		category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Audio light switch - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_205,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Audio light switch - AUDIO'),	category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_211,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('IFF Mode 4 - ON'),		category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_211,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('IFF Mode 4 - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-1 switch - M-1'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-1 switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_206,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-1 switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-2 switch - M-2'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-2 switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_207,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-2 switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-3/A switch - M-3/A'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-3/A switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_208,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-3/A switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('TEST M-C switch - M-C'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('TEST M-C switch - ON'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_209,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('TEST M-C switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('RAD TEST switch - RAD TEST'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('RAD TEST switch - OUT'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_210,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('RAD TEST switch - MON'),	category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('IDENT switch - IDENT'),category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('IDENT switch - OUT'),	category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_220,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('IDENT switch - MIC'),category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_715, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 1 - X0 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_715, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 1 - X0 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_716, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 1 - 0X Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_716, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 1 - 0X Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_717, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - X000 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_717, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - X000 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_718, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 0X00 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_718, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 0X00 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_719, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 00X0 Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_719, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 00X0 Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_720, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('MODE 3 - 000X Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_720, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('MODE 3 - 000X Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_721, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Master switch Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_721, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Master switch Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

{combos = {},down = device_commands.Button_722, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Code select Decrease'), category = {_('Main instrument panel'), _('IFF panel')}},
{combos = {},down = device_commands.Button_722, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Code select Increase'), category = {_('Main instrument panel'), _('IFF panel')}},

--Adjust Rudder Pedals

{combos = {},	down = device_commands.Button_888, up= device_commands.Button_888, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up= 1.0 ,name = _('Adjust Rudder Pedals Handle'),category = {_('Systems')}},
{combos = {},pressed = device_commands.Button_890,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Adjust Rudder Pedals - Backward'),category = {_('Systems')}},
{combos = {},pressed = device_commands.Button_890,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Adjust Rudder Pedals - Forward'),	category = {_('Systems')}},


--UFH Antenna, DME SELECTOR.....
{combos = {},down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('V/UHF Antennas Selector - UP'),		category = {_('Main instrument panel')}},
{combos = {},down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('V/UHF Antennas Selector - AUT'),		category = {_('Main instrument panel')}},
{combos = {},down = device_commands.Button_221,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('V/UHF Antennas Selector - DOWN'),	category = {_('Main instrument panel')}},

{combos = {},down = device_commands.Button_6,cockpit_device_id = devices.VIR31A_DME40,	value_down = 1.0,	name = _('DME selector switch - HOLD'),		category = {_('Main instrument panel')}},
{combos = {},down = device_commands.Button_6,cockpit_device_id = devices.VIR31A_DME40,	value_down = 0.0,	name = _('DME selector switch - NORM'),	category = {_('Main instrument panel')}},

{combos = {},down = device_commands.Button_28,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Radio altimeter switch - ON'),		category = {_('Main instrument panel')}},
{combos = {},down = device_commands.Button_28,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Radio altimeter switch - OFF'),	category = {_('Main instrument panel')}},

{combos = {},down = device_commands.Button_26, up = device_commands.Button_26, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up = 0.0,	name = _('ELT switch - TEST/AUT'),		category = {_('Main instrument panel')}},

-------------------------------------------------------------Main Left panel-----------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

--Anti-Rain
{combos = {}, down = device_commands.Button_222, up = device_commands.Button_222, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Rain fluid'), category = _('Main instrument panel')},
--landing light
{combos = {{key = 'L', reformers = {'LCtrl','LAlt'}}},	    down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Left Spotlight switch - landing'),		category = {_('Main instrument panel'), _('Illumination')}},
{combos = {{key = 'L', reformers = {'LCtrl'}}},		down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Left Spotlight switch - taxi'),	category = {_('Main instrument panel'), _('Illumination')}},
{combos = {{key = 'L', reformers = {'LShift'}}},	down = device_commands.Button_109,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Left Spotlight switch - OFF'),	category = {_('Main instrument panel'), _('Illumination')}},
{combos = {{key = 'L', reformers = {'RAlt'}}},	    down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Right Spotlight switch - landing'),		category = {_('Main instrument panel'), _('Illumination')}},
{combos = {{key = 'L', reformers = {'RCtrl'}}},		down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Right Spotlight switch - taxi'),	category = {_('Main instrument panel'), _('Illumination')}},
{combos = {{key = 'L', reformers = {'RShift'}}},	down = device_commands.Button_110,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Right Spotlight switch - OFF'),	category = {_('Main instrument panel'), _('Illumination')}},
--Pitot heat
{combos = {{key = 'H', reformers = {'LWin'}}}, down = device_commands.Button_201, up = device_commands.Button_201, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pitot heat'), category = _('Main instrument panel')},
--STALL
{combos = {}, down = device_commands.Button_199, up = device_commands.Button_199, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Stall warning test - RESET'), category = _('Main instrument panel')},
{combos = {}, down = device_commands.Button_223, up = device_commands.Button_223, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stall warning test - TEST'), category = _('Main instrument panel')},
{combos = {},	down = device_commands.Button_200,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Stall warning Power - OFF'),		category = {_('Main instrument panel')}},
{combos = {},	down = device_commands.Button_200,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Stall warning Power - ON'),	category = {_('Main instrument panel')}},
--Landing gear Override
{combos = {{key = 'O'}}, down = device_commands.Button_232, up = device_commands.Button_232, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Landing gear override'), category = _('Main instrument panel')},
--PARKING brake
{combos = {{key = 'W', reformers = {'LCtrl'}}}, down = 8023, cockpit_device_id = devices.SYSTEMS, name = _("Parking brake"), category =_('Systems')},
--Gear Lever
{combos = {{key = 'G'}}, down = 8005, cockpit_device_id = devices.SYSTEMS, name = _("Landing gear toggle"), category =_('Systems')},
{combos = {}, down = 8029, cockpit_device_id = devices.SYSTEMS, name = _("Landing gear up"), category =_('Systems')},
{combos = {}, down = 8030, cockpit_device_id = devices.SYSTEMS, name = _("Landing gear down"), category =_('Systems')},

-------------------------------------------------------------Main Right panel-----------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------
--Batteries
{combos = {},	down = device_commands.Button_1,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Battery master switch - ON'),category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},	down = device_commands.Button_1,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Battery master switch - OFF'),	category = {_('Main instrument panel'), _('Electrical system panel')}},

{combos = {},   down = device_commands.Button_3, up = device_commands.Button_3, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Left Battery Isolation switch'), category = {_('Main instrument panel'), _('Electrical system panel')}},

{combos = {},   down = device_commands.Button_5, up = device_commands.Button_5, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Right Battery Isolation switch'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--Bus Tie
{combos = {},	down = device_commands.Button_6,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('DC Bus Tie - ON'),category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},	down = device_commands.Button_6,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('DC Bus Tie - OFF'),category = {_('Main instrument panel'), _('Electrical system panel')}},

--Generator
{combos = {},down = device_commands.Button_300, up = device_commands.Button_300, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Generator - RESET'), category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},   down = device_commands.Button_10,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Generator - OFF'),		category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},   down = device_commands.Button_10,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Generator - ON'),	category = {_('Main instrument panel'), _('Electrical system panel')}},

{combos = {},down = device_commands.Button_301, up = device_commands.Button_301, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Generator ground Fault'), category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},down = device_commands.Button_11, up = device_commands.Button_11, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Generator ground Overvoltage'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--ESS BUS Transfer
{combos = {}, down = device_commands.Button_8, up = device_commands.Button_8, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('ESS BUS Transfer'), category = {_('Main instrument panel'), _('Electrical system panel')}},

--inverter
{combos = {},	down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('AC inverter Norm/Alt - NORMAL'),		category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},	down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('AC inverter Norm/Alt - OFF'),	category = {_('Main instrument panel'), _('Electrical system panel')}},
{combos = {},	down = device_commands.Button_9,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('AC inverter Norm/Alt - INVERTER'),		category = {_('Main instrument panel'), _('Electrical system panel')}},

--Warning/Caution
{combos = {},	down = device_commands.Button_12,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CAWS Panel Bright'),		category = {_('Main instrument panel')}},
{combos = {},	down = device_commands.Button_12,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CAWS Panel Dim'),	category = {_('Main instrument panel')}},
{combos = {},	down = device_commands.Button_13, up= device_commands.Button_13, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Lamp test'),category = {_('Main instrument panel')}},

-------------------------------------------------------------Left Console----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
--Fuel panel
{combos = {}, down = device_commands.Button_46, up = device_commands.Button_46, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuselage tank Pump'), category = {_('Left Console'), _('Fuel panel')}},

{combos = {}, down = device_commands.Button_47, up = device_commands.Button_47, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Engine Fuel Valve'), category = {_('Left Console'), _('Fuel panel')}},

{combos = {}, down = device_commands.Button_48, up = device_commands.Button_48, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Center wing tank Qty'), category = {_('Left Console'), _('Fuel panel')}},

{combos = {}, down = device_commands.Button_49, up = device_commands.Button_49, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Test fuel Qty indicator'), category = {_('Left Console'), _('Fuel panel')}},

{combos = {},	down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Left AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Left OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_50,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Left MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{combos = {},	down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 1 AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Center 1 OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_51,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 1 MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{combos = {},	down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 2 AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Center 2 OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_52,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 2 MAN'),	category = {_('Left Console'), _('Fuel panel')}},

{combos = {},	down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Right AUT'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Fuel Transfer Right OFF'),	category = {_('Left Console'), _('Fuel panel')}},
{combos = {},	down = device_commands.Button_53,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Right MAN'),	category = {_('Left Console'), _('Fuel panel')}},

--Engine panel
--{combos = {{key = 'P', reformers = {'LShift'}}}, down = 8002, cockpit_device_id = devices.SYSTEMS, name = _("GPU Connection"), category =_('External GPU')},
{combos = {{key = 'P', reformers = {'LCtrl'}}}, down = device_commands.Button_38, up = device_commands.Button_38, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('GPU on/off'), category ={_('Left Console'), _('Engine control panel'), _('External GPU')}},

{combos = {}, down = device_commands.Button_112, up = device_commands.Button_112, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Ice'), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, down = device_commands.Button_111, up = device_commands.Button_111, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Computer'), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, down = device_commands.Button_115, up = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Ignition Mode Selector - START"), category = {_('Left Console'), _('Engine control panel')}},
{combos = {}, down = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Ignition Mode Selector - OFF"), category = {_('Left Console'), _('Engine control panel')}},
{combos = {}, down = device_commands.Button_115, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _("Ignition Mode Selector - CONTINUOUS"), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, down = device_commands.Button_114, up = device_commands.Button_114, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Abort'), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, down = device_commands.Button_116, up = device_commands.Button_116, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Ignition light test'), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, pressed = device_commands.Button_914, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Ignition Dimmer Increase'), category = {_('Left Console'), _('Engine control panel')}},
{combos = {},pressed = device_commands.Button_914, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Ignition Dimmer Decrease'), category = {_('Left Console'), _('Engine control panel')}},

{combos = {}, down = device_commands.Button_113, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _("Starter Mode Selector Crank"), category ={_('Left Console'), _('Engine control panel')}},
{combos = {}, down = device_commands.Button_113, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Starter Mode Selector Normal"), category ={_('Left Console'), _('Engine control panel')}},

--Throttle panel
{combos = {{key = 'F', reformers = {'LShift'}}}, down = 8006, cockpit_device_id = devices.SYSTEMS, name = _("Next Flap Detent"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{combos = {{key = 'F', reformers = {'LCtrl'}}}, down = 8007, cockpit_device_id = devices.SYSTEMS, name = _("Prev Flap Detent"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{combos = {}, down = 8008, up = 8010, cockpit_device_id = devices.SYSTEMS, name = _("HOTAS Flaps Up"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{combos = {}, down = 8009, up = 8010, cockpit_device_id = devices.SYSTEMS, name = _("HOTAS Flaps Down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{combos = {}, down = 8008, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Up"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{combos = {}, down = 8009, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},
{combos = {}, down = 8010, cockpit_device_id = devices.SYSTEMS, name = _("Flaps Middle"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{combos = {}, down = 8011, cockpit_device_id = devices.SYSTEMS, name = _("Toggle Flaps - one step up/down"), category ={_('Left Console'), _('Throttle panel'), _('Flight Control')}},

{combos = {{key = 'Home', reformers = {'RAlt'}}}, down = 8014, cockpit_device_id = devices.SYSTEMS, name = _("Throttle Idle Detent Toggle"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {{key = 'Home', reformers = {'RShift'}}}, down = device_commands.Button_118, cockpit_device_id = devices.SYSTEMS, value_down = 0.5, name = _("Throttle Idle Detent - Idle"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {{key = 'Home', reformers = {'RCtrl'}}}, down = device_commands.Button_118, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Throttle Idle Detent - Stop"), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {}, pressed = device_commands.Button_251, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _("C-101 Throttle Friction Increase"), category ={_('Left Console'), _('Throttle panel')}},
{combos = {}, pressed = device_commands.Button_251, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _("C-101 Throttle Friction Decrease"), category ={_('Left Console'), _('Throttle panel')}},


--[[
{combos = {{key = 'B', reformers = {'LShift'}}},down = 8011, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend'), category =_('Flight Control')},
{combos = {{key = 'B', reformers = {'LCtrl'}}},down = 8012, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Retract'), category =_('Flight Control')},
]]

{combos = {{key = 'B'}}, down = iCommandPlaneAirBrake, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend/Retract'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {{key = 'B', reformers = {'LShift'}}},down = iCommandPlaneAirBrakeOn, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Extend'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {{key = 'B', reformers = {'LCtrl'}}},down = iCommandPlaneAirBrakeOff, up = 8013, cockpit_device_id = devices.SYSTEMS, name = _('Air brake - Retract'), category ={_('Left Console'), _('Throttle lever'), _('Flight Control')}},

{combos = {{key = 'G', reformers = {'LAlt'}}},	down = device_commands.Button_202, up= device_commands.Button_202, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Landing gear warning mute'),category = {_('Left Console'), _('Throttle panel')}},

{combos = {}, down = device_commands.Button_700, up = device_commands.Button_700, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('MPR Switch'), category = {_('Left Console'), _('Throttle lever'), _('Flight Control')}},
{combos = {},	down = device_commands.Button_702, up= device_commands.Button_702, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('MPR Lamp Test'),category = {_('Main instrument panel')}},

{combos = {}, pressed = device_commands.Button_916, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('MPR Dimmer Increase'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_916, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('MPR Dimmer Decrease'), category = _('Main instrument panel')},

{combos = {}, down = device_commands.Button_903, up = device_commands.Button_903, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = ('Fuel Enrichment'), category = _('Flight Control')},

--Emergency panel
{combos = {},	down = device_commands.Button_160,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim breaker - OFF'),	category = {_('Left Console'), _('Emergency panel')}},
{combos = {},	down = device_commands.Button_160,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim breaker - ON'),	category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_158,up = device_commands.Button_158, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency Pitch Trim Lamp Test'),category = {_('Left Console'), _('Emergency panel')}},

{combos = {}, pressed = device_commands.Button_920, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Emergency Pitch Trim Dimmer Increase'), category = {_('Left Console'), _('Emergency panel')}},
{combos = {},pressed = device_commands.Button_920, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Emergency Pitch Trim Dimmer Decrease'), category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_151,up = device_commands.Button_151, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency air brake retract'),category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_153,up = device_commands.Button_153, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Aileron HYD override'),category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_159,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Emergency landing gear extension - Extend'),	category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_156,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim cutout guard OPEN'),	category = {_('Left Console'), _('Emergency panel')}},
{combos = {},	down = device_commands.Button_156,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim cutout guard CLOSE'),	category = {_('Left Console'), _('Emergency panel')}},

{combos = {},	down = device_commands.Button_302,up = device_commands.Button_302, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Pitch trim cutout DOWN'),category = {_('Left Console'), _('Emergency panel')}},
{combos = {},	down = device_commands.Button_157,up = device_commands.Button_157, cockpit_device_id = devices.SYSTEMS, value_down =-1.0, value_up=0.0,	name = _('Pitch trim cutout UP'),category = {_('Left Console'), _('Emergency panel')}},

--{combos = {{key = 'X', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = _('Rudder Trim Right'),	category = {_('Left Console'), _('Emergency panel')}},
--{combos = {{key = 'Z', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = _('Rudder Trim Left'), category = {_('Left Console'), _('Emergency panel')}},

{combos = {{key = 'Z', reformers = {'RCtrl'}}},	down = device_commands.Button_350, up = device_commands.Button_350, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up=0.0, name = _('Rudder Trim Left'), category = {_('Left Console'), _('Emergency panel')}},
{combos = {{key = 'X', reformers = {'RCtrl'}}},	down = device_commands.Button_353, up = device_commands.Button_353, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up=0.0, name = _('Rudder Trim Right'),	category = {_('Left Console'), _('Emergency panel')}},

{combos = {{key = 'W', reformers = {'RCtrl'}}}, down = 8024, up = 8026, cockpit_device_id = devices.SYSTEMS, name = _("Seat adjustment up"), category = {_('Left Console'), _('Emergency panel')}},
{combos = {{key = 'S', reformers = {'RCtrl'}}}, down = 8025, up = 8026, cockpit_device_id = devices.SYSTEMS, name = _("Seat adjustment down"), category = {_('Left Console'), _('Emergency panel')}},

---Emergency fuel
{combos = {},	down = device_commands.Button_352, up = device_commands.Button_352, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up = 0.0,	name = _('Emergency fuel switch'),	category = {_('Left Console')}},

{combos = {},	down = device_commands.Button_355,cockpit_device_id = devices.SYSTEMS,	value_down = 1,	name = _('Emergency fuel lever Increase'),	category = {_('Left Console')}},
{combos = {},	down = device_commands.Button_355,cockpit_device_id = devices.SYSTEMS,	value_down = -1,	name = _('Emergency fuel lever Decrease'),	category = {_('Left Console')}},


--Breakers panel
{combos = {},	down = device_commands.Button_54,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB engine generator - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_54,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB engine generator - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_55,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Normal inverter - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_55,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Normal inverter - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_56,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup inverter - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_56,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup inverter - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_57,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB CAUTION/WARNING panel - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_57,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB CAUTION/WARNING panel - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_58,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Landing gear - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_58,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Landing gear - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_59,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup ADI - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_59,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup ADI - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_60,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fuel measuring system - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_60,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fuel measuring system - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_61,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N1 - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_61,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N1 - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_62,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N2 - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_62,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N2 - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_63,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ITT - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_63,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ITT - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_68,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Landing Gear/Airbrake/Trim indicators - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_68,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Landing Gear/Airbrake/Trim indicators - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_69,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_69,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_70,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VOR DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_70,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VOR DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_71,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Air-Conditioning/Pressurization - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_71,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Air-Conditioning/Pressurization - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_72,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Air brake/Anti-Skid operation - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_72,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Air brake/Anti-Skid operation - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_73,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil Pressure - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_73,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil Pressure - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_74,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fuselage tank pump - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_74,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fuselage tank pump - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_75,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Center wing tank pumps - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_75,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Center wing tank pumps - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_76,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Outer wing tank pumps - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_76,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Outer wing tank pumps - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_77,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB TACAN DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_77,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB TACAN DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_80,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB TACAN AC 26 - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_80,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB TACAN AC 26 - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_81,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil temp IND - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_81,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil temp IND - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_101,cockpit_device_id = devices.SYSTEMS,value_down = 1.0,	name = _('CB LH land/taxi light - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_101,cockpit_device_id = devices.SYSTEMS,value_down = 0.0,	name = _('CB LH land/taxi light - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_89,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Position lights and RH land/taxi lights - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_89,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Position lights and RH land/taxi lights - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_90,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Red cockpit lighting - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_90,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Red cockpit lighting - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_94,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Instruments, storm and Anti-Collision lights - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_94,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Instruments, storm and Anti-Collision lights - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_98,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Formation lights - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_98,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Formation lights - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_99,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Console lights - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_99,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Console lights - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_84,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Flaps indicator and aileron indicator - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_84,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Flaps indicator and aileron indicator - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_87,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine computer - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_87,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine computer - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_85,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine starter - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_85,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine starter - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_91,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Fire detector - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_91,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Fire detector - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_95,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB UHF - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_95,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB UHF - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},


{combos = {},	down = device_commands.Button_97,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB IFF AC 115 - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_97,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB IFF AC 115 - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_82,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Pitot Heat/Stall warning system - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_82,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Pitot Heat/Stall warning system - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_83,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Anti-Ice/Rain repellent - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_83,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Anti-Ice/Rain repellent - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_86,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB IFF PRIM DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_86,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB IFF PRIM DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_88,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB elevator trim Power - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_88,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB elevator trim Power - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_92,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VHF DC ESS - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_92,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VHF DC ESS - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_93,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB interphone - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_93,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB interphone - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_96,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Seat adjustment - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_96,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Seat adjustment - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_78,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VOR AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_78,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VOR AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_291,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB FD 28V DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_291,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB FD 28V DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_292,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB IFF - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_292,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB IFF - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_293,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ADF 26V AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_293,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ADF 26V AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_294,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ADC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_294,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ADC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_538,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Gyro platform 28V DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_538,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Gyro platform 28V DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_542,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Gyro platform 115V AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_542,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Gyro platform 11V AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_547,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Gyro platform 26V AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_547,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Gyro platform 26V AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_539,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB DME 28V DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_539,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB DME 28V DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_540,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Radio altimeter - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_540,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Radio altimeter - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_541,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ADC/FD - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_541,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ADC/FD - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_544,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Vertical gyro - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_544,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Vertical gyro - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_545,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Horizontal gyro - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_545,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Horizontal gyro - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_543,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ADF 28V DC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_543,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ADF 28V DC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_546,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB DME 26V AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_546,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB DME 26V AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

{combos = {},	down = device_commands.Button_100,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB FD 26V AC - OUT'),	category = {_('Left Console'), _('Circuit breaker main panel')}},
{combos = {},	down = device_commands.Button_100,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB FD 26V AC - IN'),	category = {_('Left Console'), _('Circuit breaker main panel')}},

--Breakers Weapons panel
{combos = {},	down = device_commands.Button_329,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon OUT left - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_329,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon OUT left - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_330,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon MID left - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_330,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon MID left - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_331,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon IN left - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_331,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon IN left - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_332,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons EMERG - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_332,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons EMERG - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_333,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons NORMAL - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_333,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons NORMAL - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_335,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons 115 VAC SIGHT - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_335,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons 115 VAC SIGHT - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_336,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon OUT right - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_336,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon OUT right - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_337,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon MID right - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_337,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon MID right - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_338,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons Pylon IN right - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_338,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons Pylon IN right - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_339,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons MACHINE GUN 1 - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_339,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons MACHINE GUN 1 - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_340,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons MACHINE GUN 2 - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_340,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons MACHINE GUN 2 - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_341,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons ARMING CONTROL - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_341,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons ARMING CONTROL - IN'),	category = {_('Circuit breaker armament panel')}},

{combos = {},	down = device_commands.Button_342,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Weapons SIGHT CAMERA - OUT'),	category = {_('Circuit breaker armament panel')}},
{combos = {},	down = device_commands.Button_342,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Weapons SIGHT CAMERA - IN'),	category = {_('Circuit breaker armament panel')}},

-------------------------------------------------------------Right Console-------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

--TELEBRIEFING
{combos = {},	down = device_commands.Button_320, up= device_commands.Button_320, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Telebriefing'),category = {_('Right Console')}},

{combos = {}, pressed = device_commands.Button_913, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Telebriefing Dimmer Increase'), category = _('Main instrument panel')},
{combos = {},pressed = device_commands.Button_913, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Telebriefing Dimmer Decrease'), category = _('Main instrument panel')},

--Illumination panel
{combos = {},   pressed = device_commands.Button_129, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Instrument lighting Decrease'), category = {_('Right Console'), _('Illumination')}},
{combos = {},   pressed = device_commands.Button_129, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Instrument lighting Increase'), category = {_('Right Console'), _('Illumination')}},

{combos = {},   pressed = device_commands.Button_127, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Console integral lighting Decrease'), category = {_('Right Console'), _('Illumination')}},
{combos = {},   pressed = device_commands.Button_127, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Console integral lighting Increase'), category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'J', reformers = {'RShift'}}},down = device_commands.Button_106,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Anti-Collision beacon - ON'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'J', reformers = {'RCtrl'}}},	down = device_commands.Button_106,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Anti-Collision beacon - OFF'),	category = {_('Right Console'), _('Illumination')}},

{combos = {},	down = device_commands.Button_103,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Storm lights - ON'),	category = {_('Right Console'), _('Illumination')}},
{combos = {},	down = device_commands.Button_103,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Storm lights - OFF'),	category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'O', reformers = {'RShift'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Formation lights - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'O', reformers = {'RCtrl'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Formation lights - OFF'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'O', reformers = {'RAlt'}}},	down = device_commands.Button_108,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Formation lights - TENUE'),	category = {_('Right Console'), _('Illumination')}},

{combos = {{key = 'N', reformers = {'RShift'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('NAV lights - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'N', reformers = {'RCtrl'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('NAV lights - OFF'),	category = {_('Right Console'), _('Illumination')}},
{combos = {{key = 'N', reformers = {'RAlt'}}},	down = device_commands.Button_107,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('NAV lights - TENUE'),	category = {_('Right Console'), _('Illumination')}},

{combos = {},	down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Red flood lighting - BRIGHT'),	category = {_('Right Console'), _('Illumination')}},
{combos = {},	down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Red flood lighting - OFF'),	category = {_('Right Console'), _('Illumination')}},
{combos = {},	down = device_commands.Button_102,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Red flood lighting - TENUE'),	category = {_('Right Console'), _('Illumination')}},

--HSI (course and heading)

{combos = {{key = 'I', reformers = {'LCtrl'}}}, pressed = device_commands.Button_29, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Course Knob Decrease'), category = _('Right Console')},
{combos = {{key = 'I', reformers = {'LShift'}}},pressed = device_commands.Button_29, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Course Knob Increase'), category = _('Right Console')},

{combos = {{key = 'I', reformers = {'RCtrl'}}}, pressed = device_commands.Button_30, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Heading Knob Decrease'), category = _('Right Console')},
{combos = {{key = 'I', reformers = {'RShift'}}},pressed = device_commands.Button_30, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Heading Knob Increase'), category = _('Right Console')},


--VHF COMM/NAV VHF-20B, VIR-31A and DME-40 panel

{combos = {}, down = device_commands.Button_355, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('VHF-NAV test switch - OFF'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_355, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('VHF-NAV test switch - DME DN/R'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_355, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _('VHF-NAV test switch - VOR UP/L'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.VHF20B, value_down = 1, name = _('VHF-NAV OFF/PWR/TEST switch Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.VHF20B, value_down = -1, name = _('VHF-NAV OFF/PWR/TEST switch Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VHF20B, value_down = 0, name = _('VHF-NAV Mode OFF'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VHF20B, value_down = 0.5, name = _('VHF-NAV Mode PWR'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VHF20B, value_down = 1, name = _('VHF-NAV Mode TEST'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_1, cockpit_device_id  = devices.VHF20B, value_down = -0.1, name = _('VHF-NAV VHF frequency selector (1 MHz) Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_1, cockpit_device_id  = devices.VHF20B, value_down = 0.1, name = _('VHF-NAV VHF frequency selector (1 MHz) Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, pressed = device_commands.Button_53, cockpit_device_id  = devices.VHF20B, value_pressed = 1, name = _('VHF-NAV Volume control COMM Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, pressed = device_commands.Button_53, cockpit_device_id  = devices.VHF20B, value_pressed = -1, name = _('VHF-NAV Volume control COMM Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_2, cockpit_device_id  = devices.VHF20B, value_down = -0.1, name = _('VHF-NAV VHF frequency selector (0.025 MHz) Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_2, cockpit_device_id  = devices.VHF20B, value_down = 0.1, name = _('VHF-NAV VHF frequency selector (0.025 MHz) Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.VIR31A_DME40, value_down = 1, name = _('VHF-NAV Control switch Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.VIR31A_DME40, value_down = -1, name = _('VHF-NAV Control switch Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0, name = _('VHF-NAV Control switch OFF'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.25, name = _('VHF-NAV Control switch NAV'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.5, name = _('VHF-NAV Control switch STBY'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.75, name = _('VHF-NAV Control switch DME'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_4, cockpit_device_id  = devices.VIR31A_DME40, value_down = 1, name = _('VHF-NAV Control switch OVRD'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_1, cockpit_device_id  = devices.VIR31A_DME40, value_down = -0.1, name = _('VHF-NAV NAV frequency selector (1 MHz) Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_1, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.1, name = _('VHF-NAV NAV frequency selector (1 MHz) Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, pressed = device_commands.Button_53, cockpit_device_id  = devices.VIR31A_DME40, value_pressed = 1, name = _('VHF-NAV Volume control NAV Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, pressed = device_commands.Button_53, cockpit_device_id  = devices.VIR31A_DME40, value_pressed = -1, name = _('VHF-NAV Volume control NAV Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_2, cockpit_device_id  = devices.VIR31A_DME40, value_down = -0.1, name = _('VHF-NAV NAV frequency selector (50 kHz) Decrease'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_2, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.1, name = _('VHF-NAV NAV frequency selector (50 kHz) Increase'), category = {_('VHF COMM/NAV panel'), _('Right Console')}},

--Intercom
{combos = {}, down = device_commands.Button_51, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('INTERCOM Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_51, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('INTERCOM Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_52, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_52, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_53, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VHF Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_53, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VHF Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_54, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VHF Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_54, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VHF Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_55, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC RX Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_55, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC RX Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_56, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('HOT MIC RX Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_56, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('HOT MIC RX Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_57, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VOR Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_57, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VOR Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_58, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VOR Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_58, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VOR Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_59, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('Marker Beacon Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_59, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('Marker Beacon Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('Marker Beacon Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('Marker Beacon Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC TX Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC TX Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_62, up = device_commands.Button_62, cockpit_device_id = devices.INTERCOM,value_down = 1.0,value_up = 0.0, name = _('INTERCOM call button'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_63, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM master volume knob Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_63, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM master volume knob Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_64, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('ADF Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_64, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('ADF Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_65, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('ADF Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_65, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('ADF Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_66, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('DME Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_66, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('DME Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_67, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('DME Volume in Intercom Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_67, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('DME Volume in Intercom Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_68, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('V/UHF Volume PUSH'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_68, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('V/UHF Volume PULL'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, pressed = device_commands.Button_69, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('V/UHF Volume Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, pressed = device_commands.Button_69, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('V/UHF Volume Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_70, cockpit_device_id  = devices.INTERCOM, value_down = -1, name = _('INTERCOM Main mode selector Decrease'), category = {_('Right Console'), _('Intercom panel')}},
{combos = {}, down = device_commands.Button_70, cockpit_device_id  = devices.INTERCOM, value_down = 1, name = _('INTERCOM Main mode selector Increase'), category = {_('Right Console'), _('Intercom panel')}},

{combos = {}, down = device_commands.Button_100, up = device_commands.Button_100, cockpit_device_id  = devices.INTERCOM, value_down = 1, value_up = 0, name = _('VoIP PTT button (custom)'), category = {_('Left Console'), _('Throttle lever')}},

--ADF-60 panel
{combos = {}, down = device_commands.Button_51, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Left 0.5 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_51, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Left 0.5 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_52, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Left 10 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_52, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Left 10 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_53, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Left 100 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_53, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Left 100 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Right 0.5 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_54, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Right 0.5 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_55, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Right 10 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_55, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Right 10 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_56, cockpit_device_id  = devices.ADF_60, value_down = -1.0, name = _('ADF Right 100 kHz Selector Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_56, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Right 100 kHz Selector Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_57, up = device_commands.Button_58, cockpit_device_id  = devices.ADF_60, value_down = 1.0, value_up = 0.0, name = _('ADF Function Selector Switch Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_57, up = device_commands.Button_58, cockpit_device_id  = devices.ADF_60, value_down = -1.0, value_up = 0.0, name = _('ADF Function Selector Switch Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, pressed = device_commands.Button_59, cockpit_device_id  = devices.ADF_60, value_pressed = -1, name = _('ADF Gain Decrease'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, pressed = device_commands.Button_59, cockpit_device_id  = devices.ADF_60, value_pressed = 1, name = _('ADF Gain Increase'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_60, cockpit_device_id  = devices.ADF_60, value_down = 0.0, name = _('ADF Tone Switch OFF'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_60, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Tone Switch ON'), category = {_('ADF panel'), _('Right Console')}},

{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.ADF_60, value_down = 1.0, name = _('ADF Transfer Switch LEFT'), category = {_('ADF panel'), _('Right Console')}},
{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.ADF_60, value_down = 0.0, name = _('ADF Transfer Switch RIGHT'), category = {_('ADF panel'), _('Right Console')}},


--Air conditioning

{combos = {},	down = device_commands.Button_120, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Air-Conditioning master switch - ON'),	category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	down = device_commands.Button_120, cockpit_device_id = devices.SYSTEMS,	value_down = 0.5,	name = _('Air-Conditioning master switch - OFF'),	category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	down = device_commands.Button_120, up = device_commands.Button_120, cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	value_up = 0.5, name = _('Air-Conditioning master switch - RESET'),	category = {_('Right Console'), _('Air conditioning panel')}},

{combos = {},down = device_commands.Button_125, up = device_commands.Button_125, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Manual temperature control - COLD'), category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},down = device_commands.Button_131, up = device_commands.Button_131, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Manual temperature control - WARM'), category = {_('Right Console'), _('Air conditioning panel')}},

{combos = {},	down = device_commands.Button_121,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Air flow mode - COCKPIT'),	category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	down = device_commands.Button_121,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Air flow mode - WINDSHIELD'),	category = {_('Right Console'), _('Air conditioning panel')}},

{combos = {},	down = device_commands.Button_123, cockpit_device_id = devices.SYSTEMS, value_down = 1.0,    name = _('Temperature mode AUTO'), category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	down = device_commands.Button_123, cockpit_device_id = devices.SYSTEMS, value_down = 0.0,    name = _('Temperature mode Manual'), category = {_('Right Console'), _('Air conditioning panel')}},

{combos = {},	down = device_commands.Button_122, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, 	name = _('Emergency ventilation OFF'), category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	down = device_commands.Button_122, cockpit_device_id = devices.SYSTEMS, value_down= 1.0, 	name = _('Emergency ventilation ON'), category = {_('Right Console'), _('Air conditioning panel')}},

{combos = {},	pressed = device_commands.Button_126, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Temperature regulation control Decrease'), category = {_('Right Console'), _('Air conditioning panel')}},
{combos = {},	pressed = device_commands.Button_126, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Temperature regulation control Increase'), category = {_('Right Console'), _('Air conditioning panel')}},

--Oxygen
{combos = {{key = 'O', reformers = {'LShift'}}},down = device_commands.Button_117,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen supply - ON'),	category = {_('Right Console'), _('Oxygen system')}},
{combos = {{key = 'O', reformers = {'LCtrl'}}},	down = device_commands.Button_117,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen supply - OFF'),	category = {_('Right Console'), _('Oxygen system')}},

{combos = {},down = device_commands.Button_996, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Oxygen Regulator Control - 100%'),	category = {_('Ejection seat'), _('Oxygen system')}},
{combos = {},	down = device_commands.Button_996, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Oxygen Regulator Control - AIRMIX'),	category = {_('Ejection seat'), _('Oxygen system')}},

-- Control Stick (miscellaneous buttons)
{combos = {}, down = device_commands.Button_905, up = device_commands.Button_905, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Rain Repelent'), category = {_('Control stick'), _('Systems')}},

{combos = {}, down = device_commands.Button_924, up = device_commands.Button_924, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Camera Button'), category = {_('Control stick'), _('Systems')}},

{combos = {{key = "Space", reformers = {"RAlt"}}}, down = device_commands.Button_926, up = device_commands.Button_926, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stores Release Button'), category = {_('Control stick'), _('Weapons')}},

{combos = {{key = "Space", reformers = {"LCtrl", "LShift"}}}, down = device_commands.Button_928, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Stores Release Guard OPEN'), category = {_('Control stick'), _('Weapons')}},
{combos = {{key = "Space", reformers = {"LCtrl", "LAlt"}}}, down = device_commands.Button_928, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Stores Release Guard CLOSE'), category = {_('Control stick'), _('Weapons')}},

{combos = {{key = 'Space'}}, down = device_commands.Button_930, up = device_commands.Button_930, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fixed Weapons Trigger'), category = {_('Control stick'), _('Weapons')}},

{combos = {{key = "Space", reformers = {"RCtrl", "RShift"}}}, down = device_commands.Button_932, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Trigger Safety Catch UNLOCK'), category = {_('Control stick'), _('Weapons')}},
{combos = {{key = "Space", reformers = {"RCtrl", "RAlt"}}}, down = device_commands.Button_932, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Trigger Safety Catch LOCK'), category = {_('Control stick'), _('Weapons')}},

-- Ejection handle
{combos = {{key = '1', reformers = {'LCtrl', 'RCtrl'}}}, down = device_commands.Button_245,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Handle PULL'),	category = {_('Ejection seat'), _('Ejection system')}},
{combos = {{key = '1', reformers = {'LAlt', 'RAlt'}}}, down = device_commands.Button_245,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Handle PUSH'),	category = {_('Ejection seat'), _('Ejection system')}},
{combos = {},pressed = device_commands.Button_934,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Ejection Seat Handle Safety Pin INSTALL'),	category = {_('Ejection seat'), _('Ejection system')}},
{combos = {},	pressed = device_commands.Button_934,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Ejection Seat Handle Safety Pin REMOVE'),	category = {_('Ejection seat'), _('Ejection system')}},

-- Control Stick show/hide
{combos = {}, down = 8032, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('SHOW/HIDE FLIGHT STICK'), category = {_('Flight Control')}},

----------------------------------------------------------------Weapons----------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

--{combos = {{key = "Space", reformers = {"RAlt"}}}, down = 8927, up = 8928, cockpit_device_id = devices.SYSTEMS, name = _('Weapon Release'), category = _('Weapons')},
--{combos = {{key = 'Space'}}, down = 8929, up = 8930, cockpit_device_id = devices.SYSTEMS, name = _("Gun Fire"), category = _('Weapons')},

----------------------------------------------------------------Blackout curtain-------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
--{combos = {}, down = device_commands.Button_557, cockpit_device_id = devices.SYSTEMS, name = _('Blackout curtain'), category = _('Systems')},

----------------------------------------------------------------Canopy emergency jettison----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{combos = {},down = device_commands.Button_226,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,name = _('Canopy emergency jettison OUT'),	category = {_('Systems')}},

----------------------------------------------------------------Canopy emergency fracturing----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{combos = {},pressed = device_commands.Button_994,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,name = _('Canopy emergency fracturing OUT'),	category = {_('Systems')}},
{combos = {},pressed = device_commands.Button_994,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,name = _('Canopy emergency fracturing IN'),	category = {_('Systems')}},
{combos = {},pressed = device_commands.Button_992,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,name = _('Canopy emergency fracturing safety pin INSTALL'),	category = {_('Systems')}},
{combos = {},pressed = device_commands.Button_992,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,name = _('Canopy emergency fracturing safety pin REMOVE'),	category = {_('Systems')}},

-------------------------------------------------------------Helmet glass-------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------------
{combos = {{key = 'H'}}, down = 8028, cockpit_device_id = devices.HELMET, name = _('Helmet glass'), category =_('General')},

-------------------------------------------------------------Illumination-------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------
--{combos = {{key = 'L',reformers = {'RShift','RCtrl'}}}, down= 3256, cockpit_device_id = devices.LIGHTS, value_down = 0, name = _('Pilot pocket light torch on-off'), category ={_('Illumination')}},

{combos = {},down = device_commands.Button_252,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Magnetic compass light - ON'),	category = {_('Illumination')}},
{combos = {},	down = device_commands.Button_252,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Magnetic compass light - OFF'),	category = {_('Illumination')}},

---------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------REAR COCKPIT--------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------Main panel----------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

-- Flight director
{combos = {},	down = device_commands.Button_661,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('FD Panel Brightness Switch - ON')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Flight director'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_661,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('FD Panel Brightness Switch - OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Flight director'), _('Rear Cockpit')}},

--Scar display panel
{combos = {}, down = device_commands.Button_638, up = device_commands.Button_638, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('SCAR Mode selector/cancel')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_711, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _('SCAR Initial cannon load Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_711, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('SCAR Initial cannon load Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('SCAR display panel'), _('Weapons'), _('Rear Cockpit')}},

--RGS2 sighting system
{combos = {},pressed = device_commands.Button_313, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Optical Sight Brightness Decrease')..' '..rearCptSuffix, category = {_('RGS2 sighting system'), _('Weapons'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_313, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Optical Sight Brightness Increase')..' '..rearCptSuffix, category = {_('RGS2 sighting system'), _('Weapons'), _('Rear Cockpit')}},

-- Jettison Panel
{combos = {}, down = device_commands.Button_639, up = device_commands.Button_639, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Emergency jettison button')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('SCAR control panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_640, up = device_commands.Button_640, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Scar light test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('SCAR control panel'), _('Rear Cockpit')}},

--AOA
{combos = {},pressed = device_commands.Button_724, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('AOA indicator knob Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_724, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('AOA indicator knob Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Altimeter
{combos = {},	pressed = device_commands.Button_20, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Altimeter setting knob - Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_20, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Altimeter setting knob - Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {},	pressed = device_commands.Button_22, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Standby altimeter setting knob - Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_22, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Standby altimeter setting knob - Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Fuel flow
{combos = {}, down = device_commands.Button_441, up = device_commands.Button_441, cockpit_device_id = devices.SYSTEMS,value_down = 0.0,value_up = 1.0, name = _('Fuel flow Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Acceleration g units
{combos = {}, down = device_commands.Button_415, up = device_commands.Button_415, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Reset Max/Min Needles')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--markers
{combos = {}, down = device_commands.Button_444, up = device_commands.Button_444, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Outer marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_445, up = device_commands.Button_445, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Middle marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_446, up = device_commands.Button_446, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Inner marker lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_908, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Outer Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_908, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Outer Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_910, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Middle Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_910, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Middle Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_912, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Inner Marker Dimmer Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_912, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Inner Marker Dimmer Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--HSI
{combos = {}, down = device_commands.Button_651, up = device_commands.Button_651, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Bearing select pushbutton')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--HSI Bright
{combos = {},pressed = device_commands.Button_447, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('HSI digit brightness Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_447, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('HSI digit brightness Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Korry Buttons- UHF, VHF, NAV
{combos = {}, down = device_commands.Button_485, up = device_commands.Button_485, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('NAV Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_486, up = device_commands.Button_486, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('UHF Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_487, up = device_commands.Button_487, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('VHF Priority')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--ADI
{combos = {}, down = device_commands.Button_688, up = device_commands.Button_688, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Attitude test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_600, up = device_commands.Button_600, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Radio altitude test switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {},pressed = device_commands.Button_602, cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('DH SET radio altimeter Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_602, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('DH SET radio altimeter Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--clock
{combos = {}, down = device_commands.Button_433, up = device_commands.Button_433, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Chronograph')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {},pressed = device_commands.Button_431, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.0, name = _('Clock set button - Push')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_431, cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Clock set button - Pull')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {},pressed = device_commands.Button_432, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.008, name = _('Clock Setting Knob - Counterclockwise')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_432, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.008, name = _('Clock Setting Knob - Clockwise')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Back Adi
{combos = {}, down = device_commands.Button_408, up = device_commands.Button_408, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Backup ADI Cage')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_923, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Pitch Reference Adjust Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_923, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Pitch Reference Adjust Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--V/UHF RADIO V/TVU-740
{combos = {}, pressed = device_commands.Button_63, up = device_commands.Button_63, cockpit_device_id  = devices.VTWU740, value_pressed = -1.0, value_up = 0.0, name = _('UHF - Test selector - R')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_74, up = device_commands.Button_74, cockpit_device_id  = devices.VTWU740, value_pressed = 1.0, value_up = 0.0, name = _('UHF - Test selector - T-A2')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_64, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - 0XX.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_64, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - 0XX.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_65, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - X0X.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_65, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - X0X.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_66, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XX0.XXX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_66, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XX0.XXX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_67, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XXX.0XX Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_67, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XXX.0XX Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_68, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - XXX.X00 Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_68, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - XXX.X00 Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_69, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Main selector Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_69, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Main selector Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_27, cockpit_device_id  = devices.VTWU740, value_down = 0, name = _('UHF - Main selector OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_27, cockpit_device_id  = devices.VTWU740, value_down = 0.1, name = _('UHF - Main selector A3')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_27, cockpit_device_id  = devices.VTWU740, value_down = 0.2, name = _('UHF - Main selector A3+G')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_27, cockpit_device_id  = devices.VTWU740, value_down = 0.3, name = _('UHF - Main selector DF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_70, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Mode Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_70, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Mode Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_28, cockpit_device_id  = devices.VTWU740, value_down = 0, name = _('UHF - Mode G')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_28, cockpit_device_id  = devices.VTWU740, value_down = 0.5, name = _('UHF - Mode M')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_28, cockpit_device_id  = devices.VTWU740, value_down = 1, name = _('UHF - Mode P')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_71, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Squelch OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_71, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Squelch ON')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_72, cockpit_device_id  = devices.VTWU740, value_pressed = -1.0, name = _('UHF - Power transmit selector - 20W')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_72, cockpit_device_id  = devices.VTWU740, value_pressed = 1.0, name = _('UHF - Power transmit selector - 5W')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_73, cockpit_device_id  = devices.VTWU740, value_down = -1.0, name = _('UHF - Channel selector Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_73, cockpit_device_id  = devices.VTWU740, value_down = 1.0, name = _('UHF - Channel selector Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('V/UHF Radio V/TVU-740'), _('Rear Cockpit')}},

--Korry CAUTION, ANTISKID...
{combos = {}, down = device_commands.Button_412, up = device_commands.Button_412, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fault Alert Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_484, up = device_commands.Button_484, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Antiskid ON/OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_413, up = device_commands.Button_413, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fire Alert test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_414, up = device_commands.Button_414, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Caution Alert Reset')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Gyro Platform Control Panel
{combos = {},down = device_commands.Button_512, up = device_commands.Button_512, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fast erect switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Gyro platform control panel'), _('Rear Cockpit')}},

--Adjust Rudder Pedals
{combos = {},	down = device_commands.Button_889, up= device_commands.Button_889, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up= 1.0 ,name = _('Adjust Rudder Pedals Handle')..' '..rearCptSuffix,category = {_('Systems'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_891,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Adjust Rudder Pedals - Backward')..' '..rearCptSuffix,category = {_('Systems'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_891,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Adjust Rudder Pedals - Forward')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},

--DME SELECTOR
{combos = {},down = device_commands.Button_16,cockpit_device_id = devices.VIR31A_DME40,	value_down = 1.0,	name = _('DME selector switch - HOLD')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},down = device_commands.Button_16,cockpit_device_id = devices.VIR31A_DME40,	value_down = 0.0,	name = _('DME selector switch - NORM')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Rear Cockpit')}},

--HSI (course and heading)
{combos = {}, pressed = device_commands.Button_525, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Course Knob Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_525, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Course Knob Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_526, cockpit_device_id = devices.SYSTEMS, value_pressed = -0.005, name = _('Heading Knob Decrease')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_526, cockpit_device_id = devices.SYSTEMS, value_pressed = 0.005, name = _('Heading Knob Increase')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--landing light
{combos = {}, down = device_commands.Button_420,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Left Spotlight switch - landing')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_420,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Left Spotlight switch - FRONT')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_421,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Right Spotlight switch - landing')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_421,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Right Spotlight switch - FRONT')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Illumination'), _('Rear Cockpit')}},

--Pitot heat
{combos = {}, down = device_commands.Button_488, up = device_commands.Button_488, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Pitot heat')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--STALL
{combos = {}, down = device_commands.Button_606, up = device_commands.Button_606, cockpit_device_id = devices.SYSTEMS,value_down = -1.0,value_up = 0.0, name = _('Stall warning test - RESET')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_608, up = device_commands.Button_608, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stall warning test - TEST')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_607,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Stall warning Power - OFF')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_607,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Stall warning Power - ON')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

--Landing gear Override
{combos = {}, down = device_commands.Button_490, up = device_commands.Button_490, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Landing gear override')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Main Right panel-----------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------
--Batteries
{combos = {}, down = device_commands.Button_401, up = device_commands.Button_401, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Left Battery Isolation switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_403, up = device_commands.Button_403, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Right Battery Isolation switch')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

--ESS BUS Transfer
{combos = {}, down = device_commands.Button_405, up = device_commands.Button_405, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('ESS BUS Transfer')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

--Warning/Caution
{combos = {},	down = device_commands.Button_406,cockpit_device_id = devices.SYSTEMS, value_down = 0.0,	name = _('CAWS Panel Bright')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_406,cockpit_device_id = devices.SYSTEMS, value_down = 1.0,	name = _('CAWS Panel Dim')..' '..rearCptSuffix,	category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_407, up= device_commands.Button_407, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up= 0.0 ,name = _('Lamp test')..' '..rearCptSuffix, category = {_('Main instrument panel'), _('Electrical system panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Left Console----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
--Fuel panel
{combos = {}, down = device_commands.Button_476, up = device_commands.Button_476, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fuselage tank Pump')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_477, up = device_commands.Button_477, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Engine Fuel Valve')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_478, up = device_commands.Button_478, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Center wing tank Qty')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},


{combos = {},	down = device_commands.Button_480,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Left ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_480,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Left MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_481,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 1 ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_481,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 1 MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_482,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Center 2 ANT')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_482,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Center 2 MAN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_483,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Fuel Transfer Right ANT')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_483,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Fuel Transfer Right MAN')..' '..rearCptSuffix, category = {_('Left Console'), _('Fuel panel'), _('Rear Cockpit')}},

--Engine panel
--{combos = {{key = 'P', reformers = {'LShift'}}}, down = 8002, cockpit_device_id = devices.SYSTEMS, name = _("GPU Connection"), category =_('External GPU')},
{combos = {}, down = device_commands.Button_422, up = device_commands.Button_422, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('GPU on/off')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('External GPU'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_424, up = device_commands.Button_424, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Anti-Ice')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_423, up = device_commands.Button_423, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Computer')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_427, up = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Ignition Mode Selector - START")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Ignition Mode Selector - OFF")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_427, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _("Ignition Mode Selector - CONTINUOUS")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_426, up = device_commands.Button_426, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Abort')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_428, up = device_commands.Button_428, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Ignition light test')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_915, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Ignition Dimmer Increase')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_915, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Ignition Dimmer Decrease')..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_425, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _("Starter Mode Selector Crank")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_425, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _("Starter Mode Selector Normal")..' '..rearCptSuffix, category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

--Throttle panel
{combos = {},	down = device_commands.Button_489, up= device_commands.Button_489, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('Landing gear warning mute')..' '..rearCptSuffix,category = {_('Left Console'), _('Engine control panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_701, up = device_commands.Button_701, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('MPR_Switch')..' '..rearCptSuffix, category = {_('Left Console'), _('Throttle lever'), _('Flight Control'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_703, up= device_commands.Button_703, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up= 0.0 ,name = _('MPR Lamp Test')..' '..rearCptSuffix,category = {_('Main instrument panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_917, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('MPR Dimmer Increase')..' '..rearCptSuffix, category = _('Main instrument panel'), _('Rear Cockpit')},
{combos = {},pressed = device_commands.Button_917, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('MPR Dimmer Decrease')..' '..rearCptSuffix, category = _('Main instrument panel'), _('Rear Cockpit')},

{combos = {}, down = device_commands.Button_904, up = device_commands.Button_904, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = ('Fuel Enrichment')..' '..rearCptSuffix, category = {_('Left Console'), _('Throttle lever'), _('Flight Control'), _('Rear Cockpit')}},

--Emergency panel
{combos = {},	down = device_commands.Button_473,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim breaker - OFF')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_473,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim breaker - ON')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_470,up = device_commands.Button_470, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency Pitch Trim Lamp Test')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_921, cockpit_device_id = devices.SYSTEMS, value_pressed = 1, name = _('Emergency Pitch Trim Dimmer Increase')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_921, cockpit_device_id = devices.SYSTEMS, value_pressed = -1, name = _('Emergency Pitch Trim Dimmer Decrease')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_436,up = device_commands.Button_436, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Emergency air brake retract')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_467,up = device_commands.Button_467, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Aileron HYD override')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_437,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Emergency landing gear extension - Extend')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_468,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Pitch trim cutout guard OPEN')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_468,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Pitch trim cutout guard CLOSE')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_493,up = device_commands.Button_493, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up=0.0,	name = _('Pitch trim cutout DOWN')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_469,up = device_commands.Button_469, cockpit_device_id = devices.SYSTEMS, value_down =-1.0, value_up=0.0,	name = _('Pitch trim cutout UP')..' '..rearCptSuffix,category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_604, up = device_commands.Button_604, cockpit_device_id = devices.SYSTEMS,	value_down = -1.0, value_up=0.0, name = _('Rudder Trim Left')..' '..rearCptSuffix, category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_609, up = device_commands.Button_609, cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, value_up=0.0, name = _('Rudder Trim Right')..' '..rearCptSuffix,	category = {_('Left Console'), _('Emergency panel'), _('Rear Cockpit')}},

--Breakers panel
{combos = {},	down = device_commands.Button_548,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Stall warning system - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_548,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Stall warning system - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_499,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB VOR DC - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_499,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB VOR DC - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_504,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Engine starter - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_504,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Engine starter - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_500,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Oil temp IND - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_500,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Oil temp IND - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_497,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB ITT - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_497,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB ITT - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_496,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N2 - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_496,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N2 - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_495,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB RPM N1 - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_495,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB RPM N1 - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_498,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_498,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB OXY SYS/HYD SYS PRESS IND - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_506,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Seat adjustment - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_506,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Seat adjustment - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_502,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Instruments and storm lights - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_502,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Instruments and storm lights - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_503,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Console lights - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_503,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Console lights - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_494,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Backup ADI - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_494,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Backup ADI - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_501,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB Red cockpit lighting - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_501,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB Red cockpit lighting - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_505,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('CB interphone - OUT')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_505,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('CB interphone - IN')..' '..rearCptSuffix,	category = {_('Circuit breaker secondary panel'), _('Rear Cockpit')}},

-------------------------------------------------------------Right Console-------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

--Illumination panel
{combos = {},   pressed = device_commands.Button_130, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Instrument lighting Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{combos = {},   pressed = device_commands.Button_130, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Instrument lighting Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{combos = {},   pressed = device_commands.Button_128, cockpit_device_id = devices.LIGHTS, value_pressed = -1, name = _('Console integral lighting Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{combos = {},   pressed = device_commands.Button_128, cockpit_device_id = devices.LIGHTS, value_pressed = 1, name = _('Console integral lighting Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_417,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Storm lights - ON')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_417,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Storm lights - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

{combos = {},	down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 1.0,	name = _('Red flood lighting - BRIGHT')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 0.5,	name = _('Red flood lighting - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_416,cockpit_device_id = devices.LIGHTS,	value_down = 0.0,	name = _('Red flood lighting - TENUE')..' '..rearCptSuffix,	category = {_('Right Console'), _('Illumination'), _('Rear Cockpit')}},

--VHF COMM/NAV VHF-20B, VIR-31A and DME-40 panel

{combos = {}, down = device_commands.Button_628, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('VHF-NAV test switch - OFF')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_628, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('VHF-NAV test switch - DME DN/R')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_628, cockpit_device_id = devices.SYSTEMS, value_down = -1.0, name = _('VHF-NAV test switch - VOR UP/L')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_59, cockpit_device_id  = devices.VHF20B, value_down = 1, name = _('VHF-NAV OFF/PWR/TEST switch Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_59, cockpit_device_id  = devices.VHF20B, value_down = -1, name = _('VHF-NAV OFF/PWR/TEST switch Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VHF20B, value_down = 0, name = _('VHF-NAV Mode OFF')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VHF20B, value_down = 0.5, name = _('VHF-NAV Mode PWR')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VHF20B, value_down = 1, name = _('VHF-NAV Mode TEST')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_11, cockpit_device_id  = devices.VHF20B, value_down = -0.1, name = _('VHF-NAV VHF frequency selector (1 MHz) Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_11, cockpit_device_id  = devices.VHF20B, value_down = 0.1, name = _('VHF-NAV VHF frequency selector (1 MHz) Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_58, cockpit_device_id  = devices.VHF20B, value_pressed = 1, name = _('VHF-NAV Volume control COMM Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_58, cockpit_device_id  = devices.VHF20B, value_pressed = -1, name = _('VHF-NAV Volume control COMM Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_12, cockpit_device_id  = devices.VHF20B, value_down = -0.1, name = _('VHF-NAV VHF frequency selector (0.025 MHz) Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_12, cockpit_device_id  = devices.VHF20B, value_down = 0.1, name = _('VHF-NAV VHF frequency selector (0.025 MHz) Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.VIR31A_DME40, value_down = 1, name = _('VHF-NAV Control switch Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_61, cockpit_device_id  = devices.VIR31A_DME40, value_down = -1, name = _('VHF-NAV Control switch Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0, name = _('VHF-NAV Control switch OFF')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.25, name = _('VHF-NAV Control switch NAV')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.5, name = _('VHF-NAV Control switch STBY')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.75, name = _('VHF-NAV Control switch DME')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_14, cockpit_device_id  = devices.VIR31A_DME40, value_down = 1, name = _('VHF-NAV Control switch OVRD')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_11, cockpit_device_id  = devices.VIR31A_DME40, value_down = -0.1, name = _('VHF-NAV NAV frequency selector (1 MHz) Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_11, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.1, name = _('VHF-NAV NAV frequency selector (1 MHz) Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.VIR31A_DME40, value_pressed = 1, name = _('VHF-NAV Volume control NAV Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_60, cockpit_device_id  = devices.VIR31A_DME40, value_pressed = -1, name = _('VHF-NAV Volume control NAV Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_12, cockpit_device_id  = devices.VIR31A_DME40, value_down = -0.1, name = _('VHF-NAV NAV frequency selector (50 kHz) Decrease')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_12, cockpit_device_id  = devices.VIR31A_DME40, value_down = 0.1, name = _('VHF-NAV NAV frequency selector (50 kHz) Increase')..' '..rearCptSuffix, category = {_('VHF COMM/NAV panel'), _('Right Console'), _('Rear Cockpit')}},

--Intercom
{combos = {}, down = device_commands.Button_74, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('INTERCOM Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_74, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('INTERCOM Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_75, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_75, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_76, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VHF Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_76, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VHF Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_77, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VHF Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_77, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VHF Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_78, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC RX Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_78, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC RX Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_79, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('HOT MIC RX Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_79, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('HOT MIC RX Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_80, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('VOR Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_80, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('VOR Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_81, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('VOR Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_81, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('VOR Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_82, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('Marker Beacon Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_82, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('Marker Beacon Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_83, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('Marker Beacon Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_83, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('Marker Beacon Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_84, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('HOT MIC TX Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_84, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('HOT MIC TX Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_85, up = device_commands.Button_85, cockpit_device_id = devices.INTERCOM,value_down = 1.0,value_up = 0.0, name = _('INTERCOM call button')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_86, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('INTERCOM master volume knob Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_86, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('INTERCOM master volume knob Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_87, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('ADF Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_87, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('ADF Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_88, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('ADF Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_88, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('ADF Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_89, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('DME Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_89, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('DME Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_90, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('DME Volume in Intercom Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_90, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('DME Volume in Intercom Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_91, cockpit_device_id  = devices.INTERCOM, value_down = 0.0, name = _('V/UHF Volume PUSH')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_91, cockpit_device_id  = devices.INTERCOM, value_down = 1.0, name = _('V/UHF Volume PULL')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, pressed = device_commands.Button_92, cockpit_device_id  = devices.INTERCOM, value_pressed = -1, name = _('V/UHF Volume Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, pressed = device_commands.Button_92, cockpit_device_id  = devices.INTERCOM, value_pressed = 1, name = _('V/UHF Volume Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_93, cockpit_device_id  = devices.INTERCOM, value_down = -1, name = _('INTERCOM Main mode selector Decrease')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_93, cockpit_device_id  = devices.INTERCOM, value_down = 1, name = _('INTERCOM Main mode selector Increase')..' '..rearCptSuffix, category = {_('Right Console'), _('Intercom panel'), _('Rear Cockpit')}},

--Oxygen
{combos = {}, down = device_commands.Button_429,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen supply - ON')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_429,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen supply - OFF')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_527,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,	name = _('Oxygen pressure warning switch - BOTH')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_527,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0,	name = _('Oxygen pressure warning switch - FRONT')..' '..rearCptSuffix,	category = {_('Right Console'), _('Oxygen system'), _('Rear Cockpit')}},

{combos = {},down = device_commands.Button_997, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, name = _('Oxygen Regulator Control - 100%')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Oxygen system'), _('Rear Cockpit')}},
{combos = {},	down = device_commands.Button_997, cockpit_device_id = devices.SYSTEMS, value_down = 0.0, name = _('Oxygen Regulator Control - AIRMIX')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Oxygen system'), _('Rear Cockpit')}},

----------------------------------------------------------------Canopy emergency jettison----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{combos = {},down = device_commands.Button_515,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0,name = _('Canopy emergency jettison OUT')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},

----------------------------------------------------------------Canopy emergency fracturing----------------------------------------
---------------------------------------------------------------------------------------------------------------------------------
{combos = {},pressed = device_commands.Button_995,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,name = _('Canopy emergency fracturing OUT')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_995,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,name = _('Canopy emergency fracturing IN')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_993,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,name = _('Canopy emergency fracturing safety pin INSTALL')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_993,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,name = _('Canopy emergency fracturing safety pin REMOVE')..' '..rearCptSuffix,	category = {_('Systems'), _('Rear Cockpit')}},

--Map Case
{combos = {},pressed = device_commands.Button_902,cockpit_device_id = devices.SYSTEMS,	value_pressed = 1.0,	name = _('Map Case Cover Open')..' '..rearCptSuffix,	category = {_('Right Console'), _('Rear Cockpit')}},
{combos = {},	pressed = device_commands.Button_902,cockpit_device_id = devices.SYSTEMS,	value_pressed = -1.0,	name = _('Map Case Cover Close')..' '..rearCptSuffix,	category = {_('Right Console'), _('Rear Cockpit')}},

-- Control Stick (miscellaneous buttons)
{combos = {}, down = device_commands.Button_906, up = device_commands.Button_906, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Rain Repelent')..' '..rearCptSuffix, category = {_('Control stick'), _('Systems'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_925, up = device_commands.Button_925, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Camera Button')..' '..rearCptSuffix, category = {_('Control stick'), _('Systems'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_927, up = device_commands.Button_927, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Stores Release Button')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_929, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Stores Release Guard OPEN')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_929, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Stores Release Guard CLOSE')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_931, up = device_commands.Button_931, cockpit_device_id = devices.SYSTEMS,value_down = 1.0,value_up = 0.0, name = _('Fixed Weapons Trigger')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},

{combos = {}, down = device_commands.Button_933, cockpit_device_id = devices.SYSTEMS,value_down = 1.0, name = _('Trigger Safety Catch UNLOCK')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_933, cockpit_device_id = devices.SYSTEMS,value_down = 0.0, name = _('Trigger Safety Catch LOCK')..' '..rearCptSuffix, category = {_('Control stick'), _('Weapons'), _('Rear Cockpit')}},

-- Ejection handle
{combos = {{key = '2', reformers = {'LCtrl', 'RCtrl'}}}, down = device_commands.Button_519,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Handle PULL')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{combos = {{key = '2', reformers = {'LAlt', 'RAlt'}}}, down = device_commands.Button_519,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Handle PUSH')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{combos = {},pressed = device_commands.Button_935,cockpit_device_id = devices.SYSTEMS, value_pressed = -1.0, name = _('Ejection Seat Handle Safety Pin INSTALL')..' '..rearCptSuffix, category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{combos = {},	pressed = device_commands.Button_935,cockpit_device_id = devices.SYSTEMS, value_pressed = 1.0, name = _('Ejection Seat Handle Safety Pin REMOVE')..' '..rearCptSuffix, category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_691,cockpit_device_id = devices.SYSTEMS,	value_down = 0.0, name = _('Ejection Seat Priority Lever ON')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},
{combos = {}, down = device_commands.Button_691,cockpit_device_id = devices.SYSTEMS,	value_down = 1.0, name = _('Ejection Seat Priority Lever OFF')..' '..rearCptSuffix,	category = {_('Ejection seat'), _('Ejection system'), _('Rear Cockpit')}},


------------------------------------------------------Autopilot------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------
--{combos = {{key = 'A'}}, down = iCommandPlaneAutopilot, name = _('Autopilot'), category = _('Autopilot')},
--{combos = {{key = 'H'}}, down = iCommandPlaneSAUHBarometric, name = _('Autopilot - Barometric Altitude Hold \'H\''), category = _('Autopilot')},
--{combos = {{key = '2', reformers = {'LAlt'}}}, down = iCommandPlaneStabHbarBank, name = _('Autopilot - Altitude And Roll Hold'), category = _('Autopilot')},
--{combos = {{key = '4', reformers = {'LAlt'}}}, down = iCommandPlaneStabHbar, name = _('Autopilot - Barometric Altitude Hold'), category = _('Autopilot')},
--{combos = {{key = '9', reformers = {'LAlt'}}}, down = iCommandPlaneStabCancel, name = _('Autopilot Disengage'), category = _('Autopilot')},


--------------------------------------------------------------------From default.lua----------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------
{combos = {{key = 'P',reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Show Pilot Body'), category = _('General')},

--------------------------------------------------------------------Flight Control------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------
{combos = {{key = 'Up'}}, down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = _('Aircraft Pitch Down'), category = _('Flight Control')},
{combos = {{key = 'Down'}}, down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = _('Aircraft Pitch Up'), category = _('Flight Control')},
{combos = {{key = 'Left'}}, down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = _('Aircraft Bank Left'), category = _('Flight Control')},
{combos = {{key = 'Right'}}, down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = _('Aircraft Bank Right'), category = _('Flight Control')},
{combos = {{key = 'Z'}}, down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = _('Aircraft Rudder Left'), category = _('Flight Control')},
{combos = {{key = 'X'}}, down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = _('Aircraft Rudder Right'), category = _('Flight Control')},

{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = _('Trim: Nose Up'), category = {_('Control stick'), _('Flight Control')}},
{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = _('Trim: Nose Down'), category = {_('Control stick'), _('Flight Control')}},
{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = _('Trim: Left Wing Down'), category = {_('Control stick'), _('Flight Control')}},
{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = _('Trim: Right Wing Down'), category = {_('Control stick'), _('Flight Control')}},

{combos = {{key = 'Num+'}}, pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Throttle Up'), category = _('Flight Control')},
{combos = {{key = 'Num-'}}, pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Throttle Down'), category = _('Flight Control')},

{down = 8033, name = _('Toggle Combined Flight Controls Mode (On/Off)'), category = _('Flight Control')},

{combos = {{key = 'W'}}, down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = _('Wheel Brake On'), category = _('Systems')},

{combos = {{key = 'E', reformers = {'LCtrl'}}}, down = iCommandPlaneEject, name = _('Eject (3 times)'), category = _('Ejection system')},

--{combos = {{key = 'Home', reformers = {'RShift'}}}, down = iCommandEnginesStart, name = _('Engines Start'), category = _('Cheat')},
--{combos = {{key = 'End', reformers = {'RShift'}}}, down = iCommandEnginesStop, name = _('Engines Stop'), category = _('Cheat')},

{combos = {{key = 'C', reformers = {'LCtrl'}}}, down = iCommandPlaneFonar, name = _('Canopy Open/Close'), category = _('Systems')},




--[[
{combos = {{key = 'F5', reformers = {'RAlt'}}}, down = iCommandAutoLockOnNearestAircraft, name = _('Auto lock on nearest aircraft'), category = _('Simplifications')},
{combos = {{key = 'F6', reformers = {'RAlt'}}}, down = iCommandAutoLockOnCenterAircraft, name = _('Auto lock on center aircraft'), category = _('Simplifications')},
{combos = {{key = 'F7', reformers = {'RAlt'}}}, down = iCommandAutoLockOnNextAircraft, name = _('Auto lock on next aircraft'), category = _('Simplifications')},
{combos = {{key = 'F8', reformers = {'RAlt'}}}, down = iCommandAutoLockOnPreviousAircraft, name = _('Auto lock on previous aircraft'), category = _('Simplifications')},
{combos = {{key = 'F9', reformers = {'RAlt'}}}, down = iCommandAutoLockOnNearestSurfaceTarget, name = _('Auto lock on nearest surface target'), category = _('Simplifications')},
{combos = {{key = 'F10', reformers = {'RAlt'}}}, down = iCommandAutoLockOnCenterSurfaceTarget, name = _('Auto lock on center surface target'), category = _('Simplifications')},
{combos = {{key = 'F11', reformers = {'RAlt'}}}, down = iCommandAutoLockOnNextSurfaceTarget, name = _('Auto lock on next surface target'), category = _('Simplifications')},
{combos = {{key = 'F12', reformers = {'RAlt'}}}, down = iCommandAutoLockOnPreviousSurfaceTarget, name = _('Auto lock on previous surface target'), category = _('Simplifications')},
--]]

-------------------------------------------------------------Net-Specific Controls------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------
{combos = {{key = 'J'}}, down = iCommandNetCrewRequestControl, name = _('Request Aircraft Control'), category = _('Flight Control')},

-------------------------------------------------------------Cheat-------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------------------
{combos = {{key = 'Home',  reformers = {'LWin'}}}, down = iCommandEnginesStart, name = ('Auto Start'), category = _('Cheat')},
{combos = {{key = 'End' ,  reformers = {'LWin'}}}, down = iCommandEnginesStop,  name = ('Auto Stop') , category = _('Cheat')},

--View Cockpit
{combos = {{key = '1'}},   down = iCommandViewCockpitChangeSeat, value_down = 1, name = _('Occupy Seat 1'),	category = _('View Cockpit')},
{combos = {{key = '2'}},   down = iCommandViewCockpitChangeSeat, value_down = 2, name = _('Occupy Seat 2'),	category = _('View Cockpit')},
{combos = {{key = 'M' }}, down = iCommandToggleMirrors, name = _('Toggle Mirrors'), category = _('View Cockpit')},

-- Cockpit Camera Motion
{combos = {{key = 'F1', reformers = {'LShift'}}},  down = iCommandViewTransposeModeOn, up = iCommandViewTransposeModeOff, name = _('Camera transpose mode (press and hold)'), category = _('View Cockpit')},
{down = iCommand_ExplorationStart, name = _('Enable visual recon mode'), category = _('View Cockpit')},

-- Wheel brake
{combos = {{key = 'X', reformers = {'LCtrl'}}},  down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = _('Wheel Brake Left On/Off'), category = _('Systems')},
{combos = {{key = 'X', reformers = {'LAlt'}}},   down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = _('Wheel Brake Right On/Off'), category = _('Systems')},

{combos = {}, down = 8027, cockpit_device_id = devices.SYSTEMS, name = _("IFR Hood"), category =_('Systems')},

-- Stick (Flight Director)
{combos = {}, down = device_commands.Button_380, up = device_commands.Button_380, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Stick Go Around button"), category = {_('Control stick'), _('Flight director')}},
{combos = {}, down = device_commands.Button_381, up = device_commands.Button_381, cockpit_device_id = devices.SYSTEMS, value_down = 1.0, value_up = 0.0, name = _("Stick Touch Control System button"), category = {_('Control stick'), _('Flight director')}},

{combos = {{key = 'H', reformers = {'RShift'}}}		   , down    = iCommandViewNightVisionGogglesOn   , name = _('Toggle goggles')   , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up  , name = _('Gain goggles up')  , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Gain goggles down'), category = _('NVG')}, 

})

return base